/*
Now let's see how we can reorder a number of dynamic Properties on a Component...

- 'getDynamicProperties' returns a cursor for Slot iteration.
- the Dynamic Properties are read into an array, reversed. The new order is then set on the remote Component.
- Look at the documentation for baja.Component and baja.Complex for other Slot related methods.
*/

baja.Ord.make("station:|slot:/BajaScriptTutorials/Reorder").get({
  ok: function (folder) {
    baja.outln("Reversing Dynamic Properties on " + folder.toPathString());
  
    var dynProps = [];
  
    // Iterate through all of the Dynamic Properties...
    folder.getSlots().dynamic().properties().each(function(slot) {
      dynProps.push(slot);
      baja.outln(slot.getName());
    });
    
    // Reverse the order of the array
    dynProps = dynProps.reverse();
    
    // Perform reorder on Server (this will make a network call)...
    folder.reorder({
      dynamicProperties: dynProps,
      ok: function() {
        baja.outln("Reading new order: " + this.toPathString());
        
        // Re-read the dynamic Properties...
        this.getSlots().dynamic().properties().each(function(slot) {
          baja.outln(slot.getName());
        });
      }
    });
  },
  lease: true
});

// Note that if other students are also going through this tutorial on this Station right now, then you may see some unexpected results!
